unit Unit3;

interface

Uses
  Windows, SysUtils, Dialogs, Forms, Graphics, Classes, Math;

function PegaParam(Param : String) : Char;
procedure ConfSenha(HandJan : Integer);
procedure MostraPreview(HandJan : Integer);

implementation

function PegaParam(Param : String) : Char;
begin
  if Param = '' then
    Result := ' '
  else if Param[1] in ['/','-'] then
    Result := UpCase(Param[2])
  else
    Result := UpCase(Param[1]);
end;

procedure ConfSenha(HandJan : Integer);
var
  SysDir : String;
  TamDir : Integer;
  LibSenha : THandle;
  FuncSenha : function(lpProvider : LPCTSTR;
    hwndOwner : hWnd; dwFlags : DWord; Reserved : DWord) : DWord; stdcall;
begin
// pega o diretrio do sistema
  SetLength(SysDir, MAX_PATH);
  TamDir := GetSystemDirectory(PChar(SysDir),MAX_PATH);
  SetLength(SysDir,TamDir);
  if (SysDir <> '') and (SysDir[Length(SysDir)] <> '\') then
    SysDir := SysDir + '\';
// abre MPR.DLL
    LibSenha := LoadLibrary(PChar(SysDir+'MPR.DLL'));
    if LibSenha <> 0 then begin
// pega ponteiro para PwdChangePasswordA
      FuncSenha := GetProcAddress(LibSenha,'PwdChangePasswordA');
// chama funo de alterao de senha
      if Assigned(FuncSenha) then
        FuncSenha('SCRSAVE', HandJan, 0, 0)
      else
        MessageDlg('Erro ao abrir funo',mtError,[mbOk],0);
      FreeLibrary(LibSenha);
   end
   else
     MessageDlg('Erro ao abrir biblioteca',mtError,[mbOk],0);
   Halt;
end;

procedure MostraPreview(HandJan : Integer);
var
  R : TRect;
  Bitmap : TBitmap;
  Canvas : TCanvas;
  LargJan,AltJan : Integer;
  FPosX, FPosY : Integer;
  FIncrX, FIncrY : Integer;
  TamBit : Integer;
begin
// a tela de preview pode demorar um pouco. Aguarda
  while not IsWindowVisible(HandJan) do
    Application.ProcessMessages;
// pega dimenses da janela
  GetWindowRect(HandJan,R);
  LargJan := R.Right - R.Left;
  AltJan := R.Bottom-R.Top;
// cria bitmap que ser desenhado
  Bitmap := TBitmap.Create;
  try
    TamBit := Max(LargJan div 10,AltJan div 10);
    Bitmap.Width := TamBit;
    Bitmap.Height := TamBit;
// cria um canvas para a janela
    Canvas := TCanvas.Create;
    Canvas.Handle := GetDC(HandJan);
    FIncrX := 1;
    FIncrY := 1;
    FPosX := 0;
    FPosY := 0;
// bitmap tem apenas um crculo branco
    try
      With Bitmap.Canvas do begin
        Brush.Color := clBlack;
        FillRect(Rect(0,0,TamBit,TamBit));
        Brush.Color := clWhite;
        Ellipse(1,1,TamBit-2,TamBit-2);
      end;
// executa preview enquanto a janela est visvel
      while IsWindowVisible(HandJan) do begin
        Canvas.Draw(FPosX,FPosY,Bitmap);
// efeito ping-pong
        Inc(FPosX,FIncrX);
        if FPosX > LargJan-TamBit then begin
          FPosX := LargJan-TamBit;
          FIncrX := -FIncrX;
        end
        else if FPosX < 0 then begin
          FPosX := 0;
          FIncrX := -FIncrX;
        end;
        Inc(FPosY,FIncrY);
        if FPosY > AltJan-TamBit then begin
          FPosY := AltJan-TamBit;
          FIncrY := -FIncrY;
        end
        else if FPosY < 0 then begin
          FPosY := 0;
          FIncrY := -FIncrY;
        end;
        Sleep(20);
        Application.ProcessMessages;
      end;
    finally
      ReleaseDC(HandJan,Canvas.Handle);
      Canvas.Free;
    end;
  finally
    Bitmap.Free;
  end;
end;

end.
